echo on
%This program demonstrates how singular value
%decomposition can be used to compress an image.

argb=imread('ndpic.jpg'); %This picture must be in your directory
a = double(rgb2gray(argb)); %We convert to gray scale and double precision

[m,n] = size(a);%size of the image

[u,s,v] = svd(a);

sv = diag(s);%singular values of a

figure(1)
plot(sv)
axis([0 100 0 (1+round(max(sv)/10))*10])
xlabel('component')
ylabel('singular value')
title('Decrease in Singular Value with Component')

figure(2)
%The next part generates a slider which allows
%you to control the number of singular values
%that you use in reconstructing the picture.  You
%need to click on the slider in the figure to get
%the images to display.

components = uicontrol('Style','Slider',...
	'Min',1,'Max',200,'Value',20,...
	'Position',[40,20,500,20],...
	'Callback','displaycomponents');
